/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.models.CustomParticleIconModel;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import slimeknights.mantle.client.model.data.IModelData;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelConfigurationWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class RetexturedModel
implements IUnbakedGeometry<RetexturedModel> {
    private final ColoredBlockModel model;
    private final Set<String> retextured;

    protected RetexturedModel(SimpleBlockModel model, Set<String> retextured) {
        this(new ColoredBlockModel(model, Collections.emptyList()), retextured);
    }

    public void resolveParents(Function<class_2960, class_1100> modelGetter, class_793 owner) {
        this.model.resolveParents(modelGetter, owner);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 transform, class_806 overrides, class_2960 location, boolean isGui3d) {
        class_1087 baked = this.model.bake(owner, baker, spriteGetter, transform, overrides, location, isGui3d);
        return new Baked(baked, owner, this.model, transform, RetexturedModel.getAllRetextured(owner, this.model.getModel(), this.retextured));
    }

    public static Set<String> getAllRetextured(class_793 owner, SimpleBlockModel model, Set<String> originalSet) {
        HashSet retextured = Sets.newHashSet(originalSet);
        for (Map textures : ModelTextureIteratable.of(owner, model)) {
            textures.forEach((name, either) -> either.ifRight(parent -> {
                if (retextured.contains(parent)) {
                    retextured.add(name);
                }
            }));
        }
        return ImmutableSet.copyOf((Collection)retextured);
    }

    protected RetexturedModel(ColoredBlockModel model, Set<String> retextured) {
        this.model = model;
        this.retextured = retextured;
    }

    public static class Baked
    extends DynamicBakedWrapper<class_1087>
    implements CustomParticleIconModel {
        private final Map<class_2960, class_1087> cache = new ConcurrentHashMap<class_2960, class_1087>();
        private final class_793 owner;
        private final ColoredBlockModel model;
        private final class_3665 transform;
        private final Set<String> retextured;

        public Baked(class_1087 baked, class_793 owner, ColoredBlockModel model, class_3665 transform, Set<String> retextured) {
            super(baked);
            this.model = model;
            this.owner = owner;
            this.transform = transform;
            this.retextured = retextured;
        }

        public Baked(class_1087 baked, class_793 owner, SimpleBlockModel model, class_3665 transform, Set<String> retextured) {
            this(baked, owner, new ColoredBlockModel(model, Collections.emptyList()), transform, retextured);
        }

        private class_1087 getRetexturedModel(class_2960 name) {
            return this.model.bakeDynamic(new RetexturedConfiguration(this.owner, this.retextured, name), this.transform);
        }

        private class_1087 getCachedModel(class_2248 block) {
            return this.cache.computeIfAbsent(ModelHelper.getParticleTexture(block), this::getRetexturedModel);
        }

        public class_1058 getParticleIcon(Object obj) {
            IModelData data;
            class_2248 block;
            if (this.retextured.contains("particle") && obj instanceof IModelData && (block = (data = (IModelData)obj).getData(RetexturedHelper.BLOCK_PROPERTY)) != null) {
                class_1058 class_10582;
                class_1087 cached = this.getCachedModel(block);
                if (cached instanceof CustomParticleIconModel) {
                    CustomParticleIconModel cachedParticle = (CustomParticleIconModel)cached;
                    class_10582 = cachedParticle.getParticleIcon((Object)data);
                } else {
                    class_10582 = cached.method_4711();
                }
                return class_10582;
            }
            class_1087 class_10872 = this.wrapped;
            if (class_10872 instanceof CustomParticleIconModel) {
                CustomParticleIconModel customParticleIconModel = (CustomParticleIconModel)class_10872;
                return customParticleIconModel.getParticleIcon(obj);
            }
            return this.wrapped.method_4711();
        }

        public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
            Object object = blockView.getBlockEntityRenderData(pos);
            if (object instanceof IModelData) {
                IModelData data = (IModelData)object;
                class_2248 block = data.getData(RetexturedHelper.BLOCK_PROPERTY);
                if (block == null) {
                    super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
                    return;
                }
                this.getCachedModel(block).emitBlockQuads(blockView, state, pos, randomSupplier, context);
            } else {
                super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            }
        }

        public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
            if (stack.method_7960() || !stack.method_7985()) {
                super.emitItemQuads(stack, randomSupplier, context);
                return;
            }
            class_2248 block = RetexturedBlockItem.getTexture(stack);
            if (block == class_2246.field_10124) {
                super.emitItemQuads(stack, randomSupplier, context);
                return;
            }
            this.getCachedModel(block).emitItemQuads(stack, randomSupplier, context);
        }

        public class_806 method_4710() {
            return RetexturedOverride.INSTANCE;
        }
    }

    private static class RetexturedOverride
    extends class_806 {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public class_1087 method_3495(class_1087 originalModel, class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int pSeed) {
            if (stack.method_7960() || !stack.method_7985()) {
                return originalModel;
            }
            class_2248 block = RetexturedBlockItem.getTexture(stack);
            if (block == class_2246.field_10124) {
                return originalModel;
            }
            return ((Baked)ModelHelper.unwrap(originalModel, Baked.class)).getCachedModel(block);
        }
    }

    public static class RetexturedConfiguration
    extends ModelConfigurationWrapper {
        private final Set<String> retextured;
        private final class_4730 texture;

        public RetexturedConfiguration(class_793 base, Set<String> retextured, class_2960 texture) {
            super(base);
            this.retextured = retextured;
            this.texture = new class_4730(class_1059.field_5275, texture);
        }

        @Override
        public boolean method_3432(String name) {
            if (this.retextured.contains(name)) {
                return !class_1047.method_4539().equals((Object)this.texture.method_24147());
            }
            return super.method_3432(name);
        }

        @Override
        public class_4730 method_24077(String name) {
            if (this.retextured.contains(name)) {
                return this.texture;
            }
            return super.method_24077(name);
        }
    }

    public static class Loader
    implements IGeometryLoader<RetexturedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public RetexturedModel read(JsonObject json, JsonDeserializationContext context) {
            ColoredBlockModel model = ColoredBlockModel.deserialize(context, json);
            Set<String> retextured = Loader.getRetextured(json);
            return new RetexturedModel(model, retextured);
        }

        public static Set<String> getRetextured(JsonObject json) {
            if (json.has("retextured")) {
                JsonElement retextured = json.get("retextured");
                if (retextured.isJsonArray()) {
                    JsonArray array = retextured.getAsJsonArray();
                    if (array.size() == 0) {
                        throw new JsonSyntaxException("Must have at least one texture in retextured");
                    }
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (int i = 0; i < array.size(); ++i) {
                        builder.add((Object)class_3518.method_15287((JsonElement)array.get(i), (String)("retextured[" + i + "]")));
                    }
                    return builder.build();
                }
                if (retextured.isJsonPrimitive()) {
                    return ImmutableSet.of((Object)retextured.getAsString());
                }
            }
            throw new JsonSyntaxException("Missing retextured, expected to find a String or a JsonArray");
        }
    }
}

